/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan 
/* - Contents: α׷ A/D CH0 CH4 ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ   CH0 ͸ Ͽ 
/*      ̴.  Լ ĵ ۸  Access ʰ,
/*     COMI_US_RetrvChannel () Ͽ ͸ Ѵ.
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		40960	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */
#define CH_BUF_SIZE	(S_FREQ * 2) 
                      
void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 4};  /* Scan channel list : 0  4 ä */
	FILE *fp;
	float *pChanBuf;
	ULONG prv_cnt=0, count;
	ULONG i;

	/* Load DLL */
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	// Set A/D range //
	COMI_AD_SetRange(hDevice, 0, -10, 10);
	COMI_AD_SetRange(hDevice, 4, -10, 10);
	
	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	/* start unlimited scan */
	long act_freq = COMI_US_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!");
		printf("%s", COMI_ErrorString (COMI_LastError())); 
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		exit(0);
	}

	/* Create a file to save data */
	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMI_US_Stop (hDevice, TRUE);
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
	}
	fprintf (fp,"   CH0\n");
	// Allocate a buffer to retrieve scan data //
	if((pChanBuf = (float *)malloc(sizeof(float)*CH_BUF_SIZE)) == NULL){
		printf("Memory allocation failed !");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_US_Stop (hDevice, TRUE);
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		exit(0);
	}
	prv_cnt = 0;
	while(!kbhit())
	{
		// CH0 SCAN͸ ´.							      //
		// prv_cnt Ŀ scan ͼ CH_BUF_SIZE     //
		//  scan ͱ ۿ ְ CH_BUF_SIZE  ũ   //
		// CH_BUF_SIZE ŭ ش.                               //
		count = COMI_US_RetrvChannel (hDevice, 0, prv_cnt+1, CH_BUF_SIZE, pChanBuf, VT_FLOAT);
		for(i=0; i<count; i++)
			fprintf (fp, "%6.2f\n", pChanBuf[i]);
		prv_cnt += count;
		printf("Number of saved data = %d\n", prv_cnt);
		Sleep(100);
	}
	
	free(pChanBuf); // Free channel buffer 
	COMI_US_Stop (hDevice, TRUE);
	fclose(fp);

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
